' ---------------------------------------------------------------------------
' This module is provided to show how to use CALL32.DLL with a 16-bit program
' such as VB3 or Access 2.0.  All the functions check to see if the app is
' running under an OS that supports it.  That way you can run the same app
' under Win31, Win95 or WinNT.
'
' The following types of functions are provided:
'
' 1) Functions that allow you to Open, Rename, Kill, Exists,
' and use Common Dialogs with Long filenames under Win95 and WinNT.
'
' 2) Functions that will make your forms and controls have a 3D look
' without using THREED.VBX.  It uses CTL3DV2.DLL which MUST to be in the
' Windows/System directory.
'
' 3) Functions that will modify the "Thumb" portion of scroll bars to
' show the page size
'
' 4) Functions that will change the settings for a form so that it doesn't
' show up on the Task Bar and will act as a app modal dialog box.
'
' --------------------------------------------------------------------------
' This code is provided as is.  No warranty is expressed or implied.
' --------------------------------------------------------------------------
'
' This code is pulled from an actual program that has over 2,000 users.  So,
' I'm pretty sure it works <g>.  If it doesn't work, try figuring it out
' before emailing me.  Great references are:
'
'  Dan Appleman's "Visual Basic Programmer's Guide to the Win32 API"
'  Microsoft's Developer's Netork CDs (MSDN)
'
' The reason that I am supplying this is to try to keep from getting emails
' concerning the use of CALL32.DLL.  I now know why Peter Golde didn't
' provide a way to contact him.
'
' ---------------------------------------------------------------------------

Option Explicit

Const GW_Owner = 4

'Const SB_HORZ% = 0
'Const SB_VERT% = 1
Const SB_CTL% = 2
'Const SB_BOTH% = 3

Const SIF_RANGE = &H1
Const SIF_PAGE = &H2
Const SIF_POS = &H4
Const SIF_DISABLENOSCROLL = &H8
Const SIF_TRACKPOS = &H10
Const SIF_ALL = (SIF_RANGE Or SIF_PAGE Or SIF_POS Or SIF_TRACKPOS)

Type tagScrollInfo
    cbSize As Long
    fmask As Long
    nMin As Long
    nMax As Long
    nPage As Long
    nPos As Long
    nTrackPos As Long
End Type

Type OpenSaveFile32
     lStructSize As Long
     hwndOwner As Long
     hInstance As Long
     lpstrFilter As Long
     lpstrCustomFilter As Long
     nMaxCustFilter As Long
     nFilterIndex As Long
     lpstrFile As Long
     nMaxFile As Long
     lpstrFileTitle As Long
     nMaxFileTitle As Long
     lpstrInitialDir As Long
     lpstrTitle As Long
     Flags As Long
     nFileOffset As Integer
     nFileExtension As Integer
     lpstrDefExt As Long
     lCustData As Long
     lpfnHook As Long
     lpTemplateName As Long
End Type


' --------------------------------------------------------
' 32-bit declares
' --------------------------------------------------------
Declare Function Declare32 Lib "CALL32.DLL" (ByVal Func$, ByVal Library$, ByVal Args$) As Long
Declare Sub FreeCall32IDs Lib "CALL32.DLL" ()

Declare Function SetScrollInfo& Lib "CALL32.DLL" Alias "Call32" (ByVal hWnd As Long, ByVal fnbar&, LPCSCROLLINFO As tagScrollInfo, ByVal BOOL&, ByVal ID&)
Declare Function GetScrollInfo& Lib "CALL32.DLL" Alias "Call32" (ByVal hWnd As Long, ByVal fnbar&, LPCSCROLLINFO As tagScrollInfo, ByVal ID&)

Declare Function GetOpenFileNameA Lib "CALL32.DLL" Alias "Call32" (pOpenSaveFile As OpenSaveFile32, ByVal ID As Long) As Integer
Declare Function GetSaveFileNameA Lib "CALL32.DLL" Alias "Call32" (pOpenSaveFile As OpenSaveFile32, ByVal ID As Long) As Integer
'Declare Function CommDlgExtendedError Lib "CALL32.DLL" Alias "Call32" (ByVal ID As Long) As Long

Declare Function GetVDMPointer32W& Lib "Kernel" (Param As Any, ByVal Mode%)
Declare Function GetCapture& Lib "CALL32.DLL" Alias "Call32" (ByVal ID As Long)
Declare Function SetCapture% Lib "User" (ByVal hWnd%)
Declare Sub ReleaseCapture Lib "User" ()
       
' Misc. memory declarations/constants
Declare Sub hmemcpy Lib "Kernel" (lpDest As Any, lpSource As Any, ByVal dwBytes As Long)
Declare Function Lstrcpy Lib "KERNEL" (p1 As Any, p2 As Any) As Long

Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer
'Declare Function GetVersion& Lib "Kernel" ()
Declare Function GetWinFlags& Lib "Kernel" ()

Const GMEM_MOVEABLE = &H2
Const GMEM_ZEROINIT = &H40
Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Type FILETIME
   dwLowDateTime     As Long
   dwHighDateTime    As Long
End Type

Const Max_Path = 260

Type Win32_Find_Data
   dwFileAttributes  As Long
   ftCreationTime    As FILETIME
   ftLastAccessTime  As FILETIME
   ftLastWriteTime   As FILETIME
   nFileSizeHigh     As Long
   nFileSizeLow      As Long
   dwReserved0       As Long
   dwReserved1       As Long
   cFileName         As String * Max_Path  'MUST be set to 260
   cAlternate        As String * 14
End Type

Declare Function FindFirstFileA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpFileName$, lpFindFileData As Win32_Find_Data, ByVal ID&)
Declare Function FindNextFileA& Lib "CALL32.DLL" Alias "Call32" (ByVal hFindFile&, lpFindFileData As Win32_Find_Data, ByVal ID&)
Declare Function FindClose& Lib "CALL32.DLL" Alias "Call32" (phHandle&, ByVal ID&)
Declare Function GetLastError& Lib "CALL32.DLL" Alias "Call32" (ByVal ID&)
Declare Function GetShortPathNameA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpLongpath$, ByVal lpShortPath$, ByVal lenpath&, ByVal ID&)
Declare Function GetFullPathNameA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpFileName$, ByVal nBufferLength&, ByVal lpBuffer$, lpFilePart&, ByVal ID&)
'Declare Function GetCurrentDirectoryA& Lib "CALL32.DLL" Alias "Call32" (ByVal nBufferLength&, ByVal lpBuffer$, ByVal ID&)
'Declare Function SetCurrentDirectoryA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpBuffer$, ByVal ID&)
Declare Function CreateFileA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpFileName$, ByVal Acc&, ByVal Share&, lpSecurity&, ByVal Create&, ByVal Flags&, ByVal Handle&, ByVal ID&)
Declare Function CloseHandle& Lib "CALL32.DLL" Alias "Call32" (ByVal Handle&, ByVal ID&)
Declare Function MoveFileA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpFileName1$, ByVal lpFileName2$, ByVal ID&)
Declare Function DeleteFileA& Lib "CALL32.DLL" Alias "Call32" (ByVal lpFileName1$, ByVal ID&)

Dim glngFindFirstID&, glngFindNextID&, glngLastErrID&, glngGetShortPathID&, glngFindCloseID&, glngFullPathID&, glngGetDirID&, glngSetDirID&, glngCreateFileID&, glngCloseHandleID&
Dim glngFormatMessageAID&, glngMoveFileID&, glngDeleteFileID&

Const File_Attribute_Directory = &H10

   'Color values to use for specific lines that give 3D look.
   'For the line, Red, Green and Blue values will all
   'be set to this value, so all three will be equal--which
   'produces a shade of grey.
   Const WHITE = 255       'Light gray/white
   Const DARKGRAY = 128    'Dark gray
   Const LightGray = 192
   Const Black = 64        'Black
   
   Dim FrameWidth%

   Const Raised = 2     'Frame is raised
   Const Recessed = 1   'Frame is recessed
   Const FLAT = 0       'No frame/3D effect
   
   Type OfStruct
     cbytes As String * 1
     fFixedDisk As String * 1
     nErrCode As Integer
     reserved As String * 4
     szPathName As String * 128
   End Type

   Declare Function OpenFileA Lib "Kernel" Alias "OpenFile" (ByVal lpFileName As String, lpReOpenBuff As OfStruct, ByVal wStyle%) As Integer
   Declare Function lclose Lib "Kernel" Alias "_lclose" (ByVal hFile As Integer) As Integer
   Const OF_EXIST = &H4000
   Const OF_Share_Deny_None = &H40
   Const OF_Create = &H1000

'Declare Function GetModuleUsage Lib "Kernel" (ByVal hModule As Integer) As Integer
'Declare Sub FreeLibrary Lib "Kernel" (ByVal hLibModule As Integer)

Const GWW_HINSTANCE% = (-6)

Dim retInt%, retLng&, RegisteredhInst%

Dim CTRL3D_Registered%

Const SEM_NOOPENFILEERRORBOX& = &H8000

Declare Function GetWindowLong& Lib "USER" (ByVal hWnd%, ByVal nIndex%)
Declare Function SetWindowLong& Lib "USER" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)

Const GWL_STYLE& = (-16)
Const COLOR_BTNFACE& = &H8000000F
Const FIXED_DOUBLE% = 3
Const Fixed_Single = 1
Const DS_MODALFRAME& = &H80&

Const SC_SEPARATOR& = &H0
Const SC_SIZE& = &HF000
Const SC_CLOSE& = &HF060
Const SC_TASKLIST& = &HF130

Declare Function SetErrorMode% Lib "KERNEL" (ByVal wMode As Integer)

Declare Sub Ctl3dRegister Lib "CTL3DV2.DLL" (ByVal hInst%)
Declare Sub Ctl3dUnregister Lib "CTL3DV2.DLL" (ByVal hInst%)
Declare Sub Ctl3dAutoSubclass Lib "CTL3DV2.DLL" (ByVal hInst%)
Declare Sub Ctl3dSubclassDlgEx Lib "CTL3DV2.DLL" (ByVal hWnd%, ByVal Flags&)

Declare Sub SetModuleExpWinVer Lib "CALL32.DLL" (ByVal hInst%, ByVal ThisVer%)
Declare Sub GetModuleExpWinVer Lib "CALL32.DLL" (ByVal hInst%, ThisVer%)
Declare Sub SetTaskExpWinVer Lib "CALL32.DLL" (ByVal hTask%, ByVal ThisVer%)
Declare Sub GetTaskExpWinVer Lib "CALL32.DLL" (ByVal hTask%, TaskVer%)

Declare Function GetCurrentTask% Lib "Kernel" ()

Global Lanversion%

Declare Function FormatMessageA& Lib "CALL32.DLL" Alias "Call32" (dwflags&, ByVal lp As Any, dwMessageId&, dwLanguageId&, ByVal lpBuffer$, nSize&, ByVal Arguments&, ByVal ID&)

Const FORMAT_MESSAGE_ALLOCATE_BUFFER = &H100&
Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200&
Const FORMAT_MESSAGE_FROM_STRING = &H400&
Const FORMAT_MESSAGE_FROM_HMODULE = &H800&
Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000&
Const FORMAT_MESSAGE_ARGUMENT_ARRAY = &H2000&
Const FORMAT_MESSAGE_MAX_WIDTH_MASK = &HFF&

Sub FreeCall32 ()
    ' Used to call the FreeCall32IDs required by Call32.DLL
    ' MUST be called before the program exits.
    If IsWin32s() Then
       Call FreeCall32IDs
    End If
End Sub

Function IsWin32s% ()
    Rem --- Checks to see if running under Win32s
    Static Inited%, Result%
    If Not Inited% Then
       Inited% = True
       Dim P$
       Result% = (IsWin95%() Or IsWinNT%()) And FilePath%("CALL32.DLL", P$)
       Rem
    End If
    IsWin32s% = Result%
    'IsWin32s% = False
End Function

Function IsWin95% ()
    Rem --- Checks to see if running under Win95
    IsWin95% = ((GetVersion%() And &HFF00) / 256) >= 95
End Function

Function IsWinNT% ()
    Rem --- Checks to see if running under WinNT
    IsWinNT% = (GetWinFlags&() And &H4000) = &H4000
End Function

Sub InitFileCalls ()
   ' helper function to set the IDs for most of the Call32 calls
   Static Inited%
   If Not Inited% Then
      glngLastErrID& = Declare32("GetLastError", "kernel32", "")
      glngFormatMessageAID& = Declare32("FormatMessageA", "kernel32", "ipiipip")
      glngFindFirstID& = Declare32("FindFirstFileA", "kernel32", "pp")
      glngFindNextID& = Declare32("FindNextFileA", "kernel32", "ip")
      glngGetShortPathID& = Declare32("GetShortPathNameA", "kernel32", "ppi")
      glngFindCloseID& = Declare32("FindClose", "kernel32", "i")
      glngFullPathID& = Declare32("GetFullPathNameA", "kernel32", "pipp")
      'glngGetDirID& = Declare32("GetCurrentDirectoryA", "kernel32", "ip")
      'glngSetDirID& = Declare32("SetCurrentDirectoryA", "kernel32", "p")
      glngCreateFileID& = Declare32("CreateFileA", "kernel32", "piipiii")
      glngCloseHandleID& = Declare32("CloseHandle", "kernel32", "i")
      glngMoveFileID& = Declare32("MoveFileA", "kernel32", "pp")
      glngDeleteFileID& = Declare32("DeleteFileA", "kernel32", "p")
      Inited% = True
   End If
End Sub


' functions that deal with Long filenames / Short filenames

Function KillFile% (File$)
     ' replaces the KILL statement and handles long filenames
     KillFile% = False
     On Local Error GoTo NoKill
     If IsWin32s%() Then
	Dim Result&
	Result& = DeleteFileA&(File$, glngDeleteFileID&)
     Else
	Kill GetShortFileName$(File$)
     End If
     KillFile% = True
     Exit Function
NoKill:
     Resume Next
     Exit Function
End Function

Function LongDir$ (Pattern$)
     ' replaces the DIR$() function and handles long filenames
     Static Inited%, Win32%, FindHandle&, Win32Data As Win32_Find_Data
     Dim ShortName$, LongName$, Result&

     If Not Inited% Then
	Win32% = IsWin32s%()
	If Win32% Then Call InitFileCalls
	Inited% = True
     End If

     If Win32% Then
	LongName$ = ""
	If Len(Pattern$) Then
	   If FindHandle& Then
	      Result& = FindClose(FindHandle&, glngFindCloseID&)
	      FindHandle& = 0
	   End If
	   FindHandle& = FindFirstFileA&(Pattern$, Win32Data, glngFindFirstID&)
	   If FindHandle& <> -1 Then
	      Call GetNamesFromStruct(Win32Data, LongName$, ShortName$)
	   End If
	Else
	   Result& = FindNextFileA&(ByVal FindHandle&, Win32Data, glngFindNextID&)
	   If Result& = 1 Then
	      Call GetNamesFromStruct(Win32Data, LongName$, ShortName$)
	   Else
	      LongName$ = ""
	   End If
	End If
	LongDir$ = LongName$
     Else
	If Len(Pattern$) Then
	   LongDir$ = LCase$(Dir$(Pattern$))
	Else
	   LongDir$ = LCase$(Dir$)
	End If
     End If

End Function


Function OpenFile% (ShareType$, Num%, LongFile$, FilLen%)
   ' replaces the OPEN statement and handles long filenames

   Rem - THIS FUNCTION TRYS TO OPEN THE FILES AS BEST AS POSSIBLE
   Rem - IT RETURNS False IF NOT ABLE TO OPEN
   Dim NumTrys%, File$, Exists%
   OpenFile% = False: NumTrys% = 0
   On Local Error GoTo OPENERROR

   Exists% = FILEEXIST%(LongFile$)

   If Not Exists% Then
      Select Case ShareType$
	  Case "I"
	  Case Else
	     Call CreateFile(LongFile$)
	     Rem
      End Select
   End If
   File$ = GetShortFileName$(LongFile$)

TRYLAN:
   If Lanversion% Then
      Select Case ShareType$
	Case "BS"
	   Open File$ For Binary Access Read Lock Write As #Num% Len = FilLen%
	Case "BR"
	   Open File$ For Binary Access Read As #Num% Len = FilLen%
	Case "BL"
	   Open File$ For Binary Access Read Write Lock Read Write As #Num% Len = FilLen%
	Case "RS"
	   Open File$ For Random Access Read Lock Write As #Num% Len = FilLen%
	Case "RR"
	   Open File$ For Random Access Read As #Num% Len = FilLen%
	Case "RL"
	   Open File$ For Random Access Read Write Lock Read Write As #Num% Len = FilLen%
	Case "O"
	   Open File$ For Output Access Write Lock Read Write As #Num% Len = FilLen%
	Case "A"
	   Open File$ For Append Access Write Lock Read Write As #Num% Len = FilLen%
	Case "I"
	   Open File$ For Input Access Read As #Num% Len = FilLen%
	Case Else
	   ErrorBox 256, 0
      End Select
      OpenFile% = True
      Exit Function
   End If

NoLan:
      Select Case ShareType$
	Case "BL", "BS", "BR"
	   Open File$ For Binary As #Num%
	Case "RL", "RS", "RR"
	   Open File$ For Random As #Num% Len = FilLen%
	Case "O"
	   Open File$ For Output As #Num% Len = FilLen%
	Case "A"
	   Open File$ For Append As #Num% Len = FilLen%
	Case "I"
	   Open File$ For Input As #Num% Len = FilLen%
	Case Else
	   'Errorbox 256,0
      End Select
      OpenFile% = True
      Exit Function

OPENERROR:
   Close #Num%
   If Err = 70 And Lanversion% Then
      If NumTrys% < 2 Then
	 NumTrys% = NumTrys% + 1
	 Call SLEEPIT(1)
	 Resume TRYLAN
      Else
	 Exit Function
      End If
   ElseIf Err = 73 And NumTrys% < 1 Then
      NumTrys% = NumTrys% + 1
      Resume NoLan
   Else
      Exit Function
   End If

End Function

Function FILEEXIST% (File$)
   ' checks to see if a file exists, better than len(dir$())
   Dim Result&, RecOpenBuff As OfStruct
   
   FILEEXIST% = True
   On Local Error Resume Next
   'F$ = Dir$(GetShortFileName$(File$))
   RecOpenBuff.cbytes = Chr$(Len(RecOpenBuff))
   Result& = OpenFileA(GetShortFileName$(File$), RecOpenBuff, OF_EXIST Or OF_Share_Deny_None)
   
   'If Err > 0 Or Len(F$) = 0 Then
   If Err > 0 Or Result& < 1 Then
      FILEEXIST% = False
   ElseIf RecOpenBuff.nErrCode > 0 Then
      MsgBox "Error #" & Str$(RecOpenBuff.nErrCode), 0
      FILEEXIST% = False
   End If
End Function

Function FileNameOnly$ (FileName$)
    ' returns the file name with the extension stripped off
    ' but with the path still attached
    If Len(FileName$) = 0 Then FileNameOnly$ = "": Exit Function
    Dim Start%, I%, LastOne%, LastSlash%
    Start% = InStr(FileName$, "\")
    While Start%
       LastSlash% = Start%
       Start% = InStr(Start% + 1, FileName$, "\")
    Wend
    Start% = InStr(LastSlash% + 1, FileName$, ".")
    While Start%
       LastOne% = Start%
       Start% = InStr(Start% + 1, FileName$, ".")
    Wend
    If LastOne% > 0 Then
       FileNameOnly$ = Left$(FileName$, LastOne% - 1)
    Else
       FileNameOnly$ = FileName$
    End If
End Function

Function FilePathOnly$ (FileName$)
    ' returns the path part of a filename
    Dim LastOne%, Start%
    LastOne% = 0
    Start% = InStr(FileName$, "\")
    Do While Start% > 0
       LastOne% = Start%
       Start% = InStr(Start% + 1, FileName$, "\")
    Loop
    If LastOne% = 0 Then
       If Mid$(FileName$, 2, 1) = ":" Then LastOne% = 2
    End If
    FilePathOnly$ = Left$(FileName$, LastOne%)
End Function

Function GetLongFileName$ (ShortFileName$)
    ' returns a long filename give a short filename
    Static Inited%

    GetLongFileName = ShortFileName$

    If Not IsWin32s%() Then
       Exit Function
    End If

    If Not Inited% Then
       Call InitFileCalls
       Inited% = True
    End If

    Dim Win32Data  As Win32_Find_Data
    Dim FirstFileHandle&, ShortName$, LongName$, Path$, NumBytes&
    ' Find the first file in the passed directory
    FirstFileHandle& = FindFirstFileA&(ShortFileName$, Win32Data, glngFindFirstID&)
    If FirstFileHandle& <> -1 Then
       Call GetNamesFromStruct(Win32Data, LongName$, ShortName$)
       NumBytes& = FindClose(ByVal FirstFileHandle&, glngFindCloseID&)

       Path$ = GetLongPathName$(ShortFileName$)
       If Len(LongName$) > 0 Then
	  GetLongFileName = FilePathOnly$(Path$) & LongName$
       Else
	  GetLongFileName = ShortFileName$
       End If
   End If
End Function

Function GetLongPathName$ (Path$)
       ' returns a long pathname give a short pathname
       Dim Buffer$, Result&, MemAddr&
       If IsWin32s%() Then
	  Buffer$ = String$(Max_Path, 0)
	  Result& = GetFullPathNameA&(Path$, Len(Buffer$), Buffer$, MemAddr&, glngFullPathID&)
       End If
       If Result& > 0 Then
	  GetLongPathName$ = Left$(Buffer$, Result&)
       Else
	  GetLongPathName$ = LCase$(Path$)
       End If
End Function

Sub GetNamesFromStruct (Win32Data As Win32_Find_Data, LongName$, ShortName$)
    ' helper function for reading info from Win32Data structure
    ' Get the long and short names (cut at first NULL)
    LongName$ = Win32Data.cFileName
    LongName$ = zstrip$(LongName$)
    ShortName$ = Win32Data.cAlternate
    ShortName$ = zstrip$(ShortName$)
    If Len(ShortName$) = 0 Then
       Mid$(LongName$, 1) = Left$(LongName$, 1) & LCase$(Mid$(LongName$, 2))
    End If
End Sub

Function GetShortFileName$ (LongFileName$)
    ' returns a short filename from a Long filename
    Static Inited%

    GetShortFileName = LongFileName$

    If Not IsWin32s%() Then
       Exit Function
    End If

    If Not Inited% Then
       Call InitFileCalls
       Inited% = True
    End If

    Dim Win32Data As Win32_Find_Data
    Dim FirstFileHandle&, ShortName$, LongName$, Path$, NumBytes&
    ' Find the first file in the passed directory
    FirstFileHandle& = FindFirstFileA&(LongFileName$, Win32Data, glngFindFirstID&)
    If FirstFileHandle& <> -1 Then
       Call GetNamesFromStruct(Win32Data, LongName$, ShortName$)
       NumBytes& = FindClose(ByVal FirstFileHandle&, glngFindCloseID&)

       Path$ = getshortpathname$(FilePathOnly$(LongFileName$))
       If Len(ShortName$) > 0 Then
	  GetShortFileName = Path$ & ShortName$
       Else
	  GetShortFileName = Path$ & LongName$
       End If
    End If

End Function

Function GetShortPathname$ (Path$)
       ' returns a Short pathname given a Long filename
       Dim P$, NumBytes&
       If IsWin32s%() Then
	  P$ = Path$ & String$(Max_Path - Len(Path$), 0)
	  NumBytes& = GetShortPathNameA&(ByVal P$, ByVal P$, Len(P$), glngGetShortPathID&)
       End If
       If NumBytes& Then
	  getshortpathname$ = Left$(P$, NumBytes&)
       Else
	  getshortpathname$ = Path$
       End If
End Function

Function GetCurrentPath$ ()
      ' returns the current Long Pathname - replaces CurDir$()
      Dim Path$
      Path$ = CurDir$
      If IsWin32s%() Then
	 'Dim Buffer$, result&
	 'Buffer$ = String$(Max_Path, 0)
	 'result& = GetCurrentDirectoryA&(Len(Buffer$), Buffer$, glngGetDirID&)
	 'GetCurrentPath$ = Left$(Buffer$, result&)
	 Rem - parse the path to get the long file names
	 Dim NumParam%, TmpPath$, I%
	 ReDim parameter$(64)
	 NumParam% = Parse(Path$, parameter$(), "\")
	 TmpPath$ = ""
	 Path$ = TmpPath$
	 For I% = 0 To NumParam%
	     TmpPath$ = TmpPath$ & parameter$(I%)
	     If Right$(TmpPath$, 1) = ":" Then
		Path$ = TmpPath$
	     Else
		Path$ = GetLongFileName$(Path$ & "\" & parameter$(I%))
	     End If
	 Next I%
	 If Right$(Path$, 1) = ":" Then Path$ = Path$ & "\"
      End If
      GetCurrentPath$ = Path$
End Function

Sub SetCurrentPath (Path$)
    ' sets the the current path - given a Long pathname
    ' replaces ChDrive, ChDir statments

    On Error Resume Next
    Err = 0
    If InStr(Path$, ":") Then
       ChDrive Path$
       If Err Then Exit Sub
    End If
    ChDir GetShortFileName$(Path$)
End Sub

Sub GetLongDirs (List As ListBox, Pattern$)
        ' populates a list box with Long directory names

	Static Win32Data As Win32_Find_Data, Inited%

	If Not Inited% Then
	   Call InitFileCalls
	   Inited% = True
	End If

	Dim FindHandle&, Result&, LongName$, ShortName$
	List.Clear
	FindHandle& = FindFirstFileA&(Pattern$, Win32Data, glngFindFirstID&)
	If FindHandle& <> -1 Then
	   Result& = 1
	   Do While Result = 1
	      If (Win32Data.dwFileAttributes And File_Attribute_Directory) Then
		 Call GetNamesFromStruct(Win32Data, LongName$, ShortName$)
		 If LongName$ <> "." Then
		    If LongName$ = UCase$(LongName$) Then
		       Mid$(LongName$, 1) = Left$(LongName$, 1) & LCase$(Mid$(LongName$, 2))
		    Else
		       Rem
		    End If
		    List.AddItem "[" & LongName$ & "]"
		 End If
	      End If
	      Result& = FindNextFileA&(ByVal FindHandle&, Win32Data, glngFindNextID&)
	   Loop
	   Result& = FindClose&(FindHandle&, glngFindCloseID&)
	End If
End Sub

Sub CreateFile (File$)
    ' will create a file with a Long filename
    If IsWin32s%() Then
       Dim Handle&, Result&
       Handle& = CreateFileA&(File$, 0&, 2&, ByVal 0&, 1&, &H80&, 0&, glngCreateFileID&)
       If Handle& Then
	  Result& = CloseHandle(Handle&, glngCloseHandleID&)
       End If
    End If
End Sub

Function DiskOk% (LongFile$)
      ' checks to see if a directory is OK to write to
      Dim Result&, RecOpenBuff As OfStruct

      On Local Error Resume Next

      If IsWin32s%() Then
	 Result& = CreateFileA&(LongFile$, 0&, 2&, ByVal 0&, 1&, &H80&, 0&, glngCreateFileID&)
      Else
	 RecOpenBuff.cbytes = Chr$(Len(RecOpenBuff))
	 Result& = OpenFileA(GetShortFileName$(LongFile$), RecOpenBuff, OF_Create)
      End If

      If Err > 0 Or Result& < 1 Then
	 DiskOk% = False
      ElseIf RecOpenBuff.nErrCode > 0 Then
	 MsgBox "Error #" & Str$(RecOpenBuff.nErrCode), 0
	 DiskOk% = False
      Else
	 If IsWin32s%() Then
	    Result& = CloseHandle(Result&, glngCloseHandleID&)
	 Else
	    If lclose(CInt(Result&)) Then
	    End If
	 End If
	 If KillFile%(GetShortFileName$(LongFile$)) Then
	 End If
	 DiskOk% = True
      End If
End Function

Sub RenameFile (File1$, File2$)
    ' replaces the NAME Statement and handles long filenames
    If IsWin32s%() Then
       Dim Result&
       Result& = MoveFileA&(File1$, File2$, glngMoveFileID&)
    Else
       Name File1$ As File2$
    End If
End Sub


' -------------------------------------------------------------------
' Common Dialog for Opening / Saving with Long filenames

Function DialogFile$ (ByVal hWnd%, Title$, DirPath$, FileSpec$, Filters$, DefaultExt$, OpenFile%, Flags&, Ext$, FilterIndex)

'   allows you to Use the Open&Save Dialog boxes under Win95/WinNT

'   Sample call:
'   opening ... DirPath$ = "C:\WINDOWS\VB"
'               FileSpec$ = ""  ' limits to only matching files (wildcards allowed *.*)
'               Filters$ = "Graphic Files|*.bmp; *.ico|Text Files|*.txt"
'               OpenFile% = True
'               tmpfile$ = DialogFile(DirPath$,FileSpec$, Filters$, OpenFile%)

'   saving .... DirPath$ = "C:\WINDOWS\VB\PROJECTS"
'               FileSpec$ = "MYFILE.RPT"  ' default file name
'               Filters$ = "Report Files|*.rpt"
'               OpenFile% = False
'               tmpfile$ = DialogFile(DirPath$,FileSpec$, Filters$, OpenFile%)

    Dim rc%, FileSize%, MemHndl%, MemAddr&, MemAddr32&
    Dim FileTitle$, Result&

    Static Inited%, Win32%, idGetOpenFileName&, idGetSaveFileName&, IdCommErr&
    
    If Not Inited% Then
       If IsWin32s%() Then
	  ' we are in Win32
	  Win32% = True
	  idGetOpenFileName& = Declare32("GetOpenFileNameA", "comdlg32.dll", "p")
	  idGetSaveFileName& = Declare32("GetSaveFileNameA", "comdlg32.dll", "p")
	  'IdCommError& = Declare32("CommDlgExtendedError", "comdlg32.dll", "")
       Else
	  Win32% = False
	  Exit Function
       End If
       Inited% = True
    End If
    
    Do While InStr(Filters$, "|") <> False
	Mid$(Filters$, InStr(Filters$, "|"), 1) = NullChar$  ' Separate with NULL
    Loop
    Filters$ = Filters$ & NullChar$ & NullChar$  ' Terminate with double NULL
    FileTitle$ = String$(Max_Path, 0)

    FileSpec$ = FileSpec$ & String$(Max_Path - Len(FileSpec$), 0)
    FileSize% = Len(FileSpec$) + Len(Filters$)
    FileSpec$ = FileSpec$ & Filters$ & FileTitle$

    MemHndl% = GlobalAlloc(GHND, Len(FileSpec$))
    If MemHndl% = False Then Exit Function
    MemAddr& = GlobalLock(MemHndl%)

    Call hmemcpy(ByVal MemAddr&, ByVal (FileSpec$), Len(FileSpec$))

    'If OpenFile% = True Then Flags = Flags Or OFN_FILEMUSTEXIST
    'If OpenFile% = False Then Flags = Flags Or OFN_OVERWRITEPROMPT

    Dim osFile32 As OpenSaveFile32
    osFile32.lStructSize = Len(osFile32)

    osFile32.hwndOwner = GetCapture32&(hWnd%)
    MemAddr32& = GetVDMPointer32W&(ByVal MemAddr&, 1)
    osFile32.lpstrFile = MemAddr32&
    'osFile.lpstrFileTitle = 0& 'MemAddr32 + FileSize% + 1
    'osFile.nMaxFileTitle = Len(FileTitle$)
    osFile32.lpstrFilter = MemAddr32& + FileSize% - Len(Filters$)
    osFile32.nFilterIndex = FilterIndex
    osFile32.nMaxFile = FileSize%
    If Len(Title$) Then
       Title$ = Title$ + NullChar$
       osFile32.lpstrTitle = GetVDMPointer32W&(ByVal Title$, 1)
    End If
    If Len(Ext$) Then
       Ext$ = Ext$ + NullChar$
       osFile32.lpstrDefExt = GetVDMPointer32W&(ByVal Ext$, 1)
    End If
    osFile32.Flags = Flags&

    If Len(Trim$(DirPath$)) Then  ' Convert DirPath$ to a LONG integer
	If Right$(Trim$(DirPath$), 1) = "\" Then DirPath$ = Left$(DirPath$, Len(DirPath$) - 1) + NullChar$' Strip any trailing '\'
	osFile32.lpstrInitialDir = GetVDMPointer32W&(ByVal DirPath$, 1)
    End If

    If Len(Trim$(DefaultExt$)) Then  ' Convert DefaultExt$ to a LONG integer
	osFile32.lpstrDefExt = GetVDMPointer32W&(ByVal DefaultExt$, 1)
    End If

    If OpenFile% = True Then
       rc% = GetOpenFileNameA(osFile32, idGetOpenFileName&)
    Else
       rc% = GetSaveFileNameA(osFile32, idGetSaveFileName&)
    End If
    Flags& = osFile32.Flags

    If rc% <> False Then
	Call hmemcpy(ByVal FileSpec$, ByVal MemAddr&, Len(FileSpec$))
	DialogFile = Left$(FileSpec$, InStr(FileSpec$, NullChar$) - 1)
'       Path = Left$(FileSpec$, osFile.nFileOffset)
'       Filename = Right$(FileSpec$, Len(FileSpec$) - osFile.nFileOffset)
'       Extension = Right$(FileSpec$, Len(FileSpec$) - osFile.nFileExtension)
	FilterIndex = osFile32.nFilterIndex
    Else
	'Result& = CommDlgExtendedError&(IdCommError&)
    End If

    rc% = GlobalUnlock(MemHndl%)
    rc% = GlobalFree(MemHndl%)

End Function

Function GetCapture32& (hWnd%)
   ' helper function
   Dim OldCapture%
   Static idGetCaptureID&

   If idGetCaptureID& = 0 Then
      idGetCaptureID& = Declare32("GetCapture", "User32", "")
   End If

   GetCapture32& = hWnd%
   
   'hwnd% = GetWindow%(gMainhwnd%, GW_Owner)
   'OldCapture% = SetCapture(hwnd%)
   'GetCapture32& = GetCapture(idGetCaptureID&)
   'If OldCapture% Then
   '   hwnd% = SetCapture(OldCapture%)
   'Else
   '   Call ReleaseCapture
   'End If
End Function

' -----------------------------------------------------------------------
' Functions that deal with the 3D look

Sub Define3d (frm As Form)
    ' called from the Form_Load() event of each form
    Dim I%

    frm.BackColor = COLOR_BTNFACE
    For I% = 0 To frm.Controls.Count - 1
	If TypeOf frm.Controls(I%) Is CommandButton Then
	   frm.Controls(I%).BackColor = COLOR_BTNFACE
	End If
    Next I%

    If CTRL3D_Registered = False Then Exit Sub
       ' If we have 3D...
     
       ' ...alter the frame so that 3D can affect it...
       retLng = SetWindowLong&(frm.hWnd, GWL_STYLE, GetWindowLong&(frm.hWnd, GWL_STYLE) Or DS_MODALFRAME)
	
       ' ...select the proper 3D-DLL and '3D' this form.
       'Select Case CTRL3D_Registered
	'Case 1
	'    Ctl3dSubclassDlgEx frm.hWnd, &H0
	'Case 2
	    Ctl3dSubclassDlgEx frm.hWnd, &H0
       'End Select

End Sub

Sub Form3d (frm As Form)   

  ' needs to be called in the Form_Paint event of each form to
  ' put highlights around controls

  Dim OldMode%  
  Dim I%, TLShade&, BrShade&, h%, W%, T%, L%
  
  'Convert ScaleMode of form to pixels.
  OldMode = frm.ScaleMode
  frm.ScaleMode = 3
  FrameWidth% = 1

  If frm.BorderStyle = 0 Then
    TLShade& = RGB(WHITE, WHITE, WHITE)
    BrShade& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
    For I = 1 To 3
      T = I
      L = I
      h = frm.ScaleHeight - (2 * I) - 1
      W = frm.ScaleWidth - (2 * I) - 1
      frm.Line (L, T)-Step(0, h), TLShade&   ' left side
      frm.Line (L, T)-Step(W, 0), TLShade&   ' top
      frm.Line (L + W, T)-Step(0, h), BrShade& ' right side
      frm.Line (L, T + h)-Step(W + 1, 0), BrShade&' bottom
    Next I
    frm.Line (frm.ScaleWidth - 1, 0)-Step(0, frm.ScaleHeight - 1), RGB(Black, Black, Black)' right side
    frm.Line (0, frm.ScaleHeight - 1)-Step(frm.ScaleWidth - 1, 0), RGB(Black, Black, Black)' bottom
  End If
  'Debug.Print frm.Caption, frm.Controls.Count

  For I% = 0 To frm.Controls.Count - 1
      If TypeOf frm.Controls(I%) Is ListBox Then
	 Control3d frm.Controls(I%), Recessed
      ElseIf TypeOf frm.Controls(I%) Is TextBox Then
	 Control3d frm.Controls(I%), Recessed
      ElseIf TypeOf frm.Controls(I%) Is ComboBox Then
	 Control3d frm.Controls(I%), Recessed
      ElseIf TypeOf frm.Controls(I%) Is CommandButton Then
	 frm.Controls(I%).BackColor = frm.BackColor
      End If
  Next I%
  
  frm.ScaleMode = OldMode
End Sub

Sub Fixup3d (Ctrl As Control)
  ' called when a control's visibility is changed on a form
  Dim OldMode%
  OldMode% = Ctrl.Parent.ScaleMode
  Ctrl.Parent.ScaleMode = 3
  Control3d Ctrl, Recessed
  Ctrl.Parent.ScaleMode = OldMode%
End Sub

Sub Register3d (frm As Form)
 
' Offer the opportunity to run this application without 3D.
' --> All programs by ChG_Tools bear this (partly) undocumented command
If InStr(1, Command$, "/NO3D", 1) Then Exit Sub
If IsWin32s%() Then Exit Sub
If IsVBenviron%() Then Exit Sub
If CTRL3D_Registered Then Exit Sub

Dim oldErrorMode%

On Error Resume Next

' Windows does NOT display an error message box now
' when it fails to find one of the following files.
oldErrorMode = SetErrorMode(SEM_NOOPENFILEERRORBOX)
    
    'Get the instance handle of the module that owns the window.
    RegisteredhInst = GetWindowWord%(frm.hWnd, GWW_HINSTANCE)
    
    Err = False
		
    ' ,,,register CTL3DV2.DLL...
    Ctl3dRegister RegisteredhInst
	    
    ' ...and if no error occured now...
    If Err = 0 Then
       ' ...make it perfect with this one.
	 Ctl3dAutoSubclass RegisteredhInst
	 CTRL3D_Registered = 2
    End If

' Reset the ErrorMode (just to tidy up).
oldErrorMode = SetErrorMode(oldErrorMode)

End Sub

Sub UnRegister3d (frm As Form)

' If we have 3D...
If CTRL3D_Registered = False Then Exit Sub
	 
	'...get the instance handle of the module again that owns the window...
	RegisteredhInst = GetWindowWord%(frm.hWnd, GWW_HINSTANCE)
    
	Ctl3dUnregister RegisteredhInst
	
' >>(Only needed if you swith 3D on and off at runtime)
	CTRL3D_Registered = False

End Sub

Sub Control3d (Ctrl As Control, ThreeDState%)
  ' helper function for other 3D functions 
  'Top, Left, Height, Width.
  Dim T%, L%, h%, W%
  'Counter index.
  Dim I%
  'Top/Left sides shade, Bottom/Right sides shade.
  Dim TLShade1&, BrShade1&, TLShade2&, BrShade2&   'Top/Left sides shade, Bottom/Right sides shade.
  
  'Set up colors for borders on ThreeDState%.  For recessed control:
  'top & left = dark, bottom & right = light
  'opposite for raised controls.
   T = Ctrl.Top
   L = Ctrl.Left
   h = Ctrl.Height
   W = Ctrl.Width

   If Not Ctrl.Visible Then
     BrShade2& = RGB(LightGray, LightGray, LightGray)
     TLShade1& = BrShade2&
     BrShade1& = BrShade2&
     TLShade2& = BrShade2&
   ElseIf ThreeDState% = Raised Then
     TLShade1& = RGB(WHITE, WHITE, WHITE)
     BrShade1& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
   ElseIf ThreeDState% = Recessed Then
     TLShade1& = RGB(DARKGRAY, DARKGRAY, DARKGRAY)
     BrShade1& = RGB(WHITE, WHITE, WHITE)
     TLShade2& = RGB(Black, Black, Black)
     BrShade2& = RGB(LightGray, LightGray, LightGray)
   End If
  
   If TypeOf Ctrl Is TextBox Then
      T = T - 1
      L = L - 1
      h = h + 1
      W = W + 1
      Ctrl.Parent.Line (L, T)-Step(0, h), TLShade2&   ' left side
      Ctrl.Parent.Line (L, T)-Step(W, 0), TLShade2&   ' top
      Ctrl.Parent.Line (L + W, T)-Step(0, h), BrShade2& ' right side
      Ctrl.Parent.Line (L, T + h)-Step(W + 1, 0), BrShade2&' bottom
   ElseIf TypeOf Ctrl Is ComboBox Then
      'T = T - 1
      'L = L - 1
      h = h - 1
      W = W - 1
   End If

   T = T - 1
   L = L - 1
   h = h + 2
   W = W + 2
   Ctrl.Parent.Line (L + W, T)-Step(0, h), BrShade1&  ' right side
   Ctrl.Parent.Line (L, T + h)-Step(W + 1, 0), BrShade1&' bottom
   Ctrl.Parent.Line (L, T)-Step(0, h), TLShade1&   ' left side
   Ctrl.Parent.Line (L, T)-Step(W, 0), TLShade1&  ' top
End Sub


' -------------------------------------------------------------------
' Routines that deal with setting the Parent of a form so that it will
' act like a dialog and not show up in the TaskBar
' -------------------------------------------------------------------

Sub RestoreDialogParent (ByVal hWnd%, ByVal OriginalParent%)
    ' OriginalParent should be a Integer Dimmed in the Form 
    If IsWin32s%() Then
       If OriginalParent% > 0 And Len(Command$) = 0 Then
	  If SetWindowWord(hWnd%, GWW_HWNDPARENT, OriginalParent%) Then
	  End If
       End If
    End If
End Sub

Sub SetDialogParams (frm As Form, OriginalParent%, ByVal NewParent%)
    ' OriginalParent should be a Integer Dimmed in the Form
    ' NewParent should be the hwnd of the "Main" form of your app
    '   or the app that you are showing this dialog on top of

    If IsWin32s%() And NewParent% > -1 And Len(Command$) = 0 Then
       OriginalParent = SetWindowWord(frm.hWnd, GWW_HWNDPARENT, NewParent%)
    End If
    Fixup_ControlBox frm
End Sub


' ----------------------------------------------------------------------
' Function that deals with setting the "Thumb/Page" size of a scrollbar
' ----------------------------------------------------------------------

Sub SetPageSize (Scroll As Control, PageSize&, AdjustMax%)

   Static Inited%, Win32s%
   Static glngSetScrollInfoID&, glngGetScrollInfoID&

   If Not Inited% Then
      Win32s% = IsWin32s%()
      If Win32s% Then
	 glngGetScrollInfoID& = Declare32("GetScrollInfo", "User32", "wip")
	 glngSetScrollInfoID& = Declare32("SetScrollInfo", "User32", "wipi")
      End If
      Inited% = True
   End If

   If Not Win32s% Then Exit Sub

   Dim ScrollInfo As tagScrollInfo
   Dim fnbar&, ret&

   ' inits the size of the structure
   ScrollInfo.cbSize = Len(ScrollInfo)

   fnbar& = SB_CTL    ' specifies that the call is for a Control

   ScrollInfo.fmask = SIF_ALL   ' what info to get

   ret& = GetScrollInfo(Scroll.hWnd, fnbar&, ScrollInfo, glngGetScrollInfoID&)
   'ret& = GetScrollInfo(Scroll.hWnd, fnbar&, ScrollInfo)

   ScrollInfo.fmask = SIF_PAGE   ' set the page size in the structure
   
   If AdjustMax% Then
      Scroll.Max = Scroll.Max + PageSize& - 1
   Else
       Rem
   End If

   ScrollInfo.nPage = PageSize& * (ScrollInfo.nMax - ScrollInfo.nMin + 1) \ (Scroll.Max - Scroll.Min + 1)
      
   ret& = SetScrollInfo(Scroll.hWnd, fnbar&, ScrollInfo, 1, glngSetScrollInfoID&)
   'ret& = SetScrollInfo(Scroll.hWnd, fnbar&, ScrollInfo, 1)
   
End Sub

' -------------------------------------------------------------------------
' Misc helper functions

Sub ShowAbout (frm As Form, About As Form)
    Dim OriginalParent%
    SetDialogParams About, OriginalParent%, frm.hWnd
    About.Show Modal
    RestoreDialogParent About.hWnd, OriginalParent%
End Sub

Sub SLEEPIT (SECONDS)
    Dim ThisTime
    ThisTime = Timer
    While Timer - ThisTime < SECONDS
      DoEvents
    Wend
End Sub

Function GetFormattedMessage$ (MsgNum&)
    ' helper function
    Dim dest$, Src$, dwflags&, Result&
    Src$ = ""
    dest$ = String$(400, 0)
    dwflags& = FORMAT_MESSAGE_FROM_SYSTEM Or FORMAT_MESSAGE_IGNORE_INSERTS
    Result& = FormatMessageA(dwflags&, 0&, MsgNum&, 0&, dest$, Len(dest$), 0&, glngFormatMessageAID&)
    GetFormattedMessage$ = zstrip$(dest$)
End Function

Function IsVBenviron% ()
    ' checks to see if running in the environment
    ' found on-line don't remember where - but I didn't write it originally

    Dim hModule%, FileBuffer$, NumberOfBytes%, ModuleFileName$, AppFileName$
    
    ' get the instance handle of the module that owns the given window
    hModule = GetWindowWord%(Forms(0).hWnd, GWW_HINSTANCE)

    ' preset the buffer that receives the null-terminated filename
    FileBuffer = Space$(128)

    ' retrieve the full path and filename of the executable file
    '  from which the specified module was loaded
    '   --> In VB environment this is the full VB.EXE path
    '       (or - not in VB environment - the app's full path)
    NumberOfBytes = GetModuleFileName(hModule, FileBuffer, Len(FileBuffer))
    ModuleFileName = Left$(FileBuffer, NumberOfBytes) 

    ' Assemble the full application path using 'App.Path' and 'App.EXEName'
    AppFileName = Backslash((App.Path)) + App.EXEName + ".EXE"
    
    ' So it doesn't matter whether VB.EXE has a different filename
    '  (as you now: you can launch a second VB instance by simply renaming VB.EXE !)
    IsVBenviron = (UCase$(ModuleFileName) <> UCase$(AppFileName))

End Function

Function Backslash$ (FilePath$)
        'helper function
	If Right$(FilePath, 1) = "\" Then
           Backslash = FilePath
        Else
           Backslash = FilePath + "\"
	End If	
End Function

