unit dbunit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    eVorname: TEdit;
    eNachname: TEdit;
    eStrasse: TEdit;
    ePLZOrt: TEdit;
    bAnfang: TButton;
    bZurueck: TButton;
    bNeu: TButton;
    bVor: TButton;
    bEnde: TButton;
    bOk: TButton;
    bLoeschen: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    eKommentar: TMemo;
    procedure bAnfangClick(Sender: TObject);
    procedure bZurueckClick(Sender: TObject);
    procedure bVorClick(Sender: TObject);
    procedure bEndeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bOkClick(Sender: TObject);
    procedure bNeuClick(Sender: TObject);
    procedure bLoeschenClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses PrBaseTE;

{$R *.DFM}

procedure ReOrg;
Begin
  dbCreateIndex('NAME','IXNAME2');
  dbIndex('IXNAME2');
End;

procedure GetSatz;
Begin
  Form1.eVorname.Text  := dbGet('VORNAME');
  Form1.eNachname.Text := dbGet('NAME');
  Form1.eStrasse.Text  := dbGet('STRASSE');
  Form1.ePLZOrt.Text   := dbGet('PLZ_ORT');
  If dbGetMemo('KOMMENTAR') > 0 Then Begin
    Form1.eKommentar.Text := GetList;
  End;
End;

procedure PutSatz;
Var P: PChar;
Begin
  dbPut('VORNAME',Form1.eVorname.Text);
  dbPut('NAME',   Form1.eNachname.Text);
  dbPut('STRASSE',Form1.eStrasse.Text);
  dbPut('PLZ_ORT',Form1.ePLZOrt.Text);
  PutList(Form1.eKommentar.Text);
  dbPutMemo('KOMMENTAR');
End;

procedure TForm1.bAnfangClick(Sender: TObject);
begin
  PutSatz;
  dbPutRec(0);
  dbGo('|<',0);
  eVorname.SetFocus;
  GetSatz;
end;

procedure TForm1.bZurueckClick(Sender: TObject);
begin
  PutSatz;
  dbPutRec(0);
  dbGo('<',1);
  eVorname.SetFocus;
  GetSatz;
end;

procedure TForm1.bVorClick(Sender: TObject);
begin
  PutSatz;
  dbPutRec(0);
  dbGo('>',1);
  eVorname.SetFocus;
  GetSatz;
end;

procedure TForm1.bEndeClick(Sender: TObject);
begin
  PutSatz;
  dbPutRec(0);
  dbGo('>|',0);
  eVorname.SetFocus;
  GetSatz;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  If dbOpen(1,'ADRESS2.DBF') < 1 Then
    dbAppendBlank;
  If Not dbIndex('IXNAME2') Then Reorg;
  dbGo('|<',0);
  GetSatz;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  dbClose(1);
end;

procedure TForm1.bOkClick(Sender: TObject);
begin
  Form1.Close;
end;

procedure TForm1.bNeuClick(Sender: TObject);
begin
  PutSatz;
  dbPutRec(0);
  dbAppendBlank;
  eVorname.SetFocus;
	GetSatz;
end;

procedure TForm1.bLoeschenClick(Sender: TObject);
begin
  dbDelete;
  dbPack;
  ReOrg;
  eVorname.SetFocus;
  GetSatz;
end;

end.
